//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property indicator_type1       DRAW_COLOR_CANDLES
#property indicator_color1      clrRed, clrRoyalBlue, clrGreen
//+----------------+
#property indicator_buffers     5
#property indicator_plots       1
//+----------------+
double  gl_Buff_High[],
        gl_Buff_Open[],
        gl_Buff_Close[],
        gl_Buff_Low[],
        gl_Buff_Color[];
//+------------------------------------------------------------------+
int OnInit()
{
   SetIndexBuffer(1, gl_Buff_High, INDICATOR_DATA);
   SetIndexBuffer(0, gl_Buff_Open, INDICATOR_DATA);
   SetIndexBuffer(3, gl_Buff_Close, INDICATOR_DATA);
   SetIndexBuffer(2, gl_Buff_Low, INDICATOR_DATA);
   SetIndexBuffer(4, gl_Buff_Color, INDICATOR_COLOR_INDEX);

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const datetime &Time[], const double &Open[], const double &High[], const double &Low[], const double &Close[], const long &TickVolume[], const long &Volume[], const int &Spread[])
{
   static double  high = DBL_MIN,
                  low = DBL_MAX;

   for (int c = (prev_calculated > 0 ? prev_calculated - 1 : 0); c < rates_total; c++)
   {
      gl_Buff_High[c] = High[c];
      gl_Buff_Open[c] = Open[c];
      gl_Buff_Close[c] = Close[c];
      gl_Buff_Low[c] = Low[c];

      gl_Buff_Color[c] = (Open[c] > Close[c] ? 0 : 2);
      if ((c - 1) > 0)
      {
         high = (High[c - 1] > high ? High[c - 1] : high);
         low = (Low[c - 1] < low ? Low[c - 1] : low);
         gl_Buff_Color[c] = ((high > High[c]) && (low < Low[c]) ? 1 : gl_Buff_Color[c]);
         if (gl_Buff_Color[c] != 1)
         {
            high = DBL_MIN;
            low = DBL_MAX;
         }
      }
   }

   return rates_total;
};
//+------------------------------------------------------------------+